/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.dskutil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import jemu.ui.dskutil.JHexEditorASCII;
import jemu.ui.dskutil.JHexEditorHEX;

public class JHexEditor
extends JPanel
implements FocusListener,
AdjustmentListener,
MouseWheelListener {
    byte[] buff;
    public int cursor;
    protected static Font font = new Font("Monospaced", 0, 12);
    protected int border = 2;
    public boolean DEBUG = false;
    private JScrollBar sb;
    private int inicio = 0;
    private int lineas = 10;
    public boolean changed = false;

    public byte[] getContent() {
        return this.buff;
    }

    public JHexEditor(byte[] buff) {
        this.buff = buff;
        this.addMouseWheelListener(this);
        this.sb = new JScrollBar(1);
        this.sb.addAdjustmentListener(this);
        this.sb.setMinimum(0);
        this.sb.setMaximum(buff.length / this.getLineas());
        JPanel p1 = new JPanel(new BorderLayout(1, 1));
        p1.add((Component)new JHexEditorHEX(this), "Center");
        p1.add((Component)new Columnas(), "South");
        JPanel p2 = new JPanel(new BorderLayout(1, 1));
        p2.add((Component)new Filas(), "Center");
        p2.add((Component)new Caja(), "South");
        JPanel p3 = new JPanel(new BorderLayout(1, 1));
        p3.add((Component)this.sb, "East");
        p3.add((Component)new JHexEditorASCII(this), "Center");
        p3.add((Component)new Caja(), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)p2, "West");
        this.add((Component)p1, "Center");
        this.add((Component)p3, "East");
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fn = this.getFontMetrics(font);
        Rectangle rec = this.getBounds();
        this.lineas = rec.height / fn.getHeight() - 1;
        int n = this.buff.length / 16 - 1;
        if (this.lineas > n) {
            this.lineas = n;
            this.inicio = 0;
        }
        this.sb.setValues(this.getInicio(), this.getLineas(), 0, this.buff.length / 16);
        this.sb.setValueIsAdjusting(true);
        super.paint(g);
    }

    protected void actualizaCursor() {
        int n = this.cursor / 16;
        System.out.print("- " + this.inicio + "<" + n + "<" + (this.lineas + this.inicio) + "(" + this.lineas + ")");
        if (n < this.inicio) {
            this.inicio = n;
        } else if (n >= this.inicio + this.lineas) {
            this.inicio = n - (this.lineas - 1);
        }
        System.out.println(" - " + this.inicio + "<" + n + "<" + (this.lineas + this.inicio) + "(" + this.lineas + ")");
        this.repaint();
    }

    protected int getInicio() {
        return this.inicio;
    }

    protected int getLineas() {
        return this.lineas;
    }

    protected void fondo(Graphics g, int x, int y, int s) {
        FontMetrics fn = this.getFontMetrics(font);
        g.fillRect((fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * y + this.border, (fn.stringWidth(" ") + 1) * s, fn.getHeight() + 1);
    }

    protected void cuadro(Graphics g, int x, int y, int s) {
        FontMetrics fn = this.getFontMetrics(font);
        g.drawRect((fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * y + this.border, (fn.stringWidth(" ") + 1) * s, fn.getHeight() + 1);
    }

    protected void printString(Graphics g, String s, int x, int y) {
        FontMetrics fn = this.getFontMetrics(font);
        g.drawString(s, (fn.stringWidth(" ") + 1) * x + this.border, fn.getHeight() * (y + 1) - fn.getMaxDescent() + this.border);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.inicio = e.getValue();
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.inicio += e.getUnitsToScroll();
        if (this.inicio + this.lineas >= this.buff.length / 16) {
            this.inicio = this.buff.length / 16 - this.lineas;
        }
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    public void setIndex(int i) {
        this.inicio = i;
        if (this.inicio + this.lineas >= this.buff.length / 16) {
            this.inicio = this.buff.length / 16 - this.lineas;
        }
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: {
                if (this.cursor >= 16 * this.lineas) {
                    this.cursor -= 16 * this.lineas;
                }
                this.actualizaCursor();
                break;
            }
            case 34: {
                if (this.cursor < this.buff.length - 16 * this.lineas) {
                    this.cursor += 16 * this.lineas;
                }
                this.actualizaCursor();
                break;
            }
            case 35: {
                this.cursor = this.buff.length - 1;
                this.actualizaCursor();
                break;
            }
            case 36: {
                this.cursor = 0;
                this.actualizaCursor();
                break;
            }
            case 37: {
                if (this.cursor != 0) {
                    --this.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 38: {
                if (this.cursor > 15) {
                    this.cursor -= 16;
                }
                this.actualizaCursor();
                break;
            }
            case 39: {
                if (this.cursor != this.buff.length - 1) {
                    ++this.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 40: {
                if (this.cursor < this.buff.length - 16) {
                    this.cursor += 16;
                }
                this.actualizaCursor();
            }
        }
    }

    private class Filas
    extends JPanel {
        public Filas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            int nl = JHexEditor.this.getLineas();
            d.setSize((fn.stringWidth(" ") + 1) * 8 + JHexEditor.this.border * 2 + 1, h * nl + JHexEditor.this.border * 2 + 1);
            return d;
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.black);
            g.setFont(font);
            int ini = JHexEditor.this.getInicio();
            int fin = ini + JHexEditor.this.getLineas();
            int y = 0;
            for (int n = ini; n < fin; ++n) {
                if (n == JHexEditor.this.cursor / 16) {
                    JHexEditor.this.cuadro(g, 0, y, 8);
                }
                String s = "0000000000000" + Integer.toHexString(n * 16);
                s = s.substring(s.length() - 8);
                JHexEditor.this.printString(g, s.toUpperCase(), 0, y++);
            }
        }
    }

    private class Caja
    extends JPanel {
        private Caja() {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            d.setSize(fn.stringWidth(" ") + 1 + JHexEditor.this.border * 2 + 1, h + JHexEditor.this.border * 2 + 1);
            return d;
        }
    }

    private class Columnas
    extends JPanel {
        public Columnas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = new Dimension();
            FontMetrics fn = this.getFontMetrics(font);
            int h = fn.getHeight();
            int nl = 1;
            d.setSize((fn.stringWidth(" ") + 1) * 47 + JHexEditor.this.border * 2 + 1, h * nl + JHexEditor.this.border * 2 + 1);
            return d;
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getMinimumSize();
            g.setColor(Color.white);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.black);
            g.setFont(font);
            for (int n = 0; n < 16; ++n) {
                if (n == JHexEditor.this.cursor % 16) {
                    JHexEditor.this.cuadro(g, n * 3, 0, 2);
                }
                String s = "00" + Integer.toHexString(n);
                s = s.substring(s.length() - 2);
                JHexEditor.this.printString(g, s.toUpperCase(), n * 3, 0);
            }
        }
    }
}

